clc; clear; 

%% Problem Data
n = 2;

Q = [0.3   -0.7
    -0.7    2.0];

% Q = 5*eye(n);

h  = [-1; .1];% + [5;5];

x0 = [-1; 1];

% computing feasible set
n_poly = 5;
A = zeros(n_poly,2);
b = zeros(n_poly,1);

theta_poly = (0:(2*pi)/n_poly:2*pi);
x_poly = cos(theta_poly);
y_poly = 1.5*sin(theta_poly-pi/10);

for i = 1:n_poly

    p = [x_poly(i+1)-x_poly(i)
         y_poly(i+1)-y_poly(i)];

    a = [p(2),-p(1)];
    a = a/norm(a);

    A(i,:) = a;

    b(i) = a*[x_poly(i); y_poly(i)];

end



%% Algorithm

options = optimoptions('quadprog','Algorithm','active-set','OptimalityTolerance',1e-8,'Display','off');
x_qp = quadprog(Q,h,A,b,[],[],[],[],x0,options);

alpha_start = 1/max(eig(Q));
% alpha_start = 1;

% Projected grad descent
[x_pgd,data,k] = PGD(@(x)(objective(x,Q,h)),Q,h,A,b,x0,alpha_start);

% beta = 0.8;
% [x_pgd,data,k] = PGD_arm(@(x)(objective(x,Q,h)),Q,h,A,b,x0,alpha_start,beta);

fprintf('Solution found by PGD\n')
disp(x_pgd)
fprintf('Function value %.4e \n',0.5*x_pgd'*Q*x_pgd + h'*x_pgd)

%% Plotting

% Plot the QP
figure(1),clf, hold on, box on
axis equal
plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region

obj = @(x,y) 0.5.*x.*Q(1,1).*x + 0.5.*y.*Q(2,2).*y + x.*Q(1,2).*y + x.*h(1)+y.*h(2);
fcontour(obj,'--','LineWidth',2)

% Plot computed optimum

plot(x_pgd(1),x_pgd(2,end),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')



% Plot the iterates and search directions

for i= 1:k
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    plot(data.x(1,i)-data.g(1,i)*data.a(i),data.x(2,i)-data.g(2,i)*data.a(i),'ro','MarkerFaceColor','g')
%     quiver(data.x(1,i),data.x(2,i),+data.d(1,i),+data.d(2,i),0,'Color','red')
    quiver(data.x(1,i),data.x(2,i),-data.g(1,i),-data.g(2,i),0,'Color','green')
    if i<k
        quiver(data.x(1,i)-data.g(1,i)*data.a(i),data.x(2,i)-data.g(2,i)*data.a(i),....
    data.x(1,i+1)-(data.x(1,i)-data.g(1,i)*data.a(i)),data.x(2,i+1)-...
    (data.x(2,i)-data.g(2,i)*data.a(i)),0,'Color','k','LineWidth',2)
        plot(data.x(1,i+1),data.x(2,i+1),'ko','MarkerFaceColor','k')
    end
%     pause
end




fprintf('Final GAP value %.4e \n',norm(data.x(:,k)-data.x(:,k-1)));

% projection function
function x = pg(y,A,b)

n = length(y);
H = eye(n);
x0 = y;
options = optimset('Display','off');
x = quadprog(H,-y,A,b,[],[],[],[],x0,options);

end






